package com.pump;

import java.awt.event.*;
import java.util.List;
import javax.swing.*;
import java.awt.*;
import java.util.LinkedList;

public class GrabbingTests {
    public static void main(String[] args) {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();

        GrabbingTests tests = new GrabbingTests(gc);
    }

    List<TestWindow> windows = new LinkedList<>();

    private GrabbingTests(GraphicsConfiguration gc) {
        Rectangle monitorBounds = gc.getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(gc);

        Rectangle insetMonitorBounds =
                new Rectangle(monitorBounds.x + insets.left,
                        monitorBounds.y + insets.top,
                        monitorBounds.width - insets.right - insets.left,
                        monitorBounds.height - insets.top - insets.bottom
                        );

        int rows = 2;
        int cols = 2;
        int windowWidth = insetMonitorBounds.width / cols - 50;
        int windowHeight = insetMonitorBounds.height / rows - 50;
        for (int y = 0; y < rows; y++) {
            for (int x = 0; x < cols; x++) {
                TestWindow f = new TestWindow(gc, this);

                Point center = new Point(
                        (int)( (.5 + x) / cols * insetMonitorBounds.width ),
                        (int)( (.5 + y) / rows * insetMonitorBounds.height )
                );

                f.setBounds(center.x - windowWidth/2, center.y - windowHeight/2, windowWidth, windowHeight);
                windows.add(f);
            }
        }

        for (Window window : windows) {
            window.setVisible(true);
        }
    }

    long last_setLeadingWindow = -1;
    Timer resetLeadingWindowTimer = new Timer(50, new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent e) {
            long elapsed = System.currentTimeMillis() - last_setLeadingWindow;
            if (elapsed > 1500) {
                setLeadingWindow(null);
                resetLeadingWindowTimer.stop();
            }
        }
    });

    void setLeadingWindow(Window newLeadingWindow) {
        if (newLeadingWindow == null) {
            for (Window w : windows) {
                w.setVisible(true);
            }
            return;
        }

        last_setLeadingWindow = System.currentTimeMillis();
        resetLeadingWindowTimer.start();

        for (Window w : windows) {
            if (w != newLeadingWindow) {
                w.setVisible(false);
            }
        }
    }
}

class TestWindow extends JFrame {
    GrabbingTests tests;

    ComponentListener componentListener = new ComponentAdapter() {

        @Override
        public void componentMoved(ComponentEvent e) {
            tests.setLeadingWindow( TestWindow.this );
        }
    };

    TestWindow(GraphicsConfiguration gc, GrabbingTests tests) {
        super(gc);
        this.tests = tests;

        addComponentListener(componentListener);
    }
}
