import javax.swing.*;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import java.awt.*;
import java.awt.desktop.AppForegroundEvent;
import java.awt.desktop.AppForegroundListener;
import java.text.DateFormat;
import java.util.Date;

/**
 * This is a simple Swing that helps demonstrate my frustration when Stage Manager helps hide
 * a JFrame. The application includes instructions on launch to explore the problem.
 */
public class StageManagerTest extends JFrame {

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable() {
            @Override
            public void run() {
                StageManagerTest test = new StageManagerTest();
                test.pack();
                test.setVisible(true);
            }
        });
    }


    JTextPane instructions = new JTextPane();
    JTextPane log = new JTextPane();
    JScrollPane scrollPane = new JScrollPane(log);

    private Boolean isAppInForeground = null;

    Runnable updateLog = new Runnable() {
        String lastMessage = null;
        @Override
        public void run() {
            StringBuilder sb = new StringBuilder();
            sb.append("\nisShowing: " + isShowing());
            sb.append("\nisAppInForeground: " + isAppInForeground);
            sb.append("\nisIconified: " + ((getExtendedState() & Frame.ICONIFIED) > 0) );

            String newLog = log.getText();

            String message = sb.toString();
            if (lastMessage == null) {
                log.setText(message + "\n");
            } else if (!lastMessage.equals(message)) {

                Date date = new Date(System.currentTimeMillis());

                newLog = newLog + "\n***** CHANGE ***** " + DateFormat.getTimeInstance().format(date) + "\n";

                newLog += message + "\n";
                log.setText(newLog);
            }
            lastMessage = message;

        }
    };

    public StageManagerTest() {

        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.APP_EVENT_FOREGROUND)) {
            Desktop.getDesktop().addAppEventListener(new AppForegroundListener() {
                @Override
                public void appRaisedToForeground(AppForegroundEvent e) {
                    isAppInForeground = true;
                }

                @Override
                public void appMovedToBackground(AppForegroundEvent e) {
                    isAppInForeground = false;
                }
            });
        }

        instructions.setText("Instructions:\n" +
                        "1. Launch this app with \"Stage Manager\" active.\n" +
                        "2. Click the yellow minimize button in the titlebar.\n" +
                        "3. After a few seconds reopen this app in the stage manager.\n" +
                        "\n" +
                        "Observed behavior: the log (in the scrollpane below) always indicates our app is in the foreground, showing, and in a normal state.\n" +
                        "\n" +
                        "Expected behavior: there should be some property we can poll/listen to to identify whether our app is showing. (Maybe the ultimate solution is to add a new property/state/listener?)"
        );


        instructions.setEditable(false);
        log.setEditable(false);

        instructions.setBorder(new EmptyBorder(10, 10, 10, 10));
        scrollPane.setBorder(new CompoundBorder(new EmptyBorder(10, 10, 10, 10), scrollPane.getBorder()));

        getContentPane().setLayout(new BorderLayout());
        getContentPane().add(instructions, BorderLayout.NORTH);
        getContentPane().add(scrollPane, BorderLayout.CENTER);

        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        scrollPane.setPreferredSize(new Dimension(200, 500));
        Thread thread = new Thread(new Runnable() {
            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(1000);

                        SwingUtilities.invokeLater(updateLog);
                    } catch(Throwable t) {

                    }
                }
            }
        }, "StageManager-log-thread");
        thread.setDaemon(true);
        thread.start();
    }
}
