
import java.util.Set;

enum OperatorType
{

   NUMERIC(Operator.EQUAL, Operator.NOT_EQUAL, Operator.GREATER_THAN, Operator.GREATER_THAN_OR_EQUAL, Operator.LESS_THAN, Operator.LESS_THAN_OR_EQUAL),
   STRING(Operator.EQUAL, Operator.NOT_EQUAL, Operator.GREATER_THAN, Operator.GREATER_THAN_OR_EQUAL, Operator.LESS_THAN, Operator.LESS_THAN_OR_EQUAL, Operator.CONTAINS),
   DATE(Operator.EQUAL, Operator.NOT_EQUAL, Operator.GREATER_THAN, Operator.GREATER_THAN_OR_EQUAL, Operator.LESS_THAN, Operator.LESS_THAN_OR_EQUAL),
   BOOLEAN(Operator.EQUAL, Operator.NOT_EQUAL),
   ;

   public final Set<Operator> operators;

   OperatorType(Operator... operators)
   {
   
      this.operators = Set.of(operators);
   
   }

}
