
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableRowSorter;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Stream;

public class ToDoList
{

   public static void main(String[] args)
   {
   
      final String[] columnNames =
         Stream
            .<ColumnName>of(ColumnName.values())
            .map(ColumnName::name)
            .toArray(String[]::new);
   
      final Object[][] data =
         {
            {"Eggs", 2, "18 count carton", 2, "All", true},
            {"2% Milk", 3, "Half Gallon", 3, "Maye", true},
            {"Whole Milk", 1, "Half Gallon", 3, "Joseph", true}
         };
   
      final DefaultTableModel defaultTableModel =
         new DefaultTableModel(data, columnNames)
         {
         
            public boolean isCellEditable(int row, int col)
            {
            
               return col == this.getColumnCount() - 1;
            
            }
         
            public Class<?> getColumnClass(int c)
            {
            
               return this.getValueAt(0, c).getClass();
            
            }
         
         };
   
      final JTable table = new JTable(defaultTableModel);
      table.setPreferredScrollableViewportSize(new Dimension(500, 70));
      table.setFillsViewportHeight(true);
      table.setRowSorter(new TableRowSorter<>(defaultTableModel));
   
      final JFrame frame = new JFrame();
      frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
   
      final Action addFilter =
         new AbstractAction("Add filter")
         {
         
            public void actionPerformed(final ActionEvent e)
            {
            
               System.out.println("Clicked a menu item! Here is e = " + e);
            
               final JDialog filterPrompt = new JDialog(frame);
               filterPrompt.setTitle("Create a filter");
               filterPrompt.setSize(300, 300);
               filterPrompt.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
            
               final JPanel filterSpecifierPanel = new JPanel(new GridLayout(1, 0));
            
               final JButton createFilterButton = new JButton("Create filter");
            
               final TableRowSorter<DefaultTableModel> sortAndFilter = new TableRowSorter<>(defaultTableModel);
            
               final JComboBox<ColumnName> cb = new JComboBox<>(ColumnName.values());
               cb.setSelectedItem(null);
               cb
                  .addActionListener
                  (
                     event ->
                     {
                     
                        List
                           .of(createFilterButton.getActionListeners())
                           .forEach(createFilterButton::removeActionListener)
                           ;
                     
                        System.out.println(event);
                     
                        if (!(cb.getSelectedItem() instanceof final ColumnName selectedColumnName))
                        {
                        
                           throw new IllegalArgumentException("How?");
                        
                        }
                     
                        final BiConsumer<JComboBox<Operator>, Collection<Operator>> addOperators =
                              (comboBox, operators) -> operators.forEach(comboBox::addItem);
                     
                        filterSpecifierPanel.removeAll();
                     
                        final JLabel columnNameLabel = new JLabel();
                        columnNameLabel.setText(selectedColumnName.name());
                     
                        final JComboBox<Operator> operators = new JComboBox<>();
                        addOperators.accept(operators, selectedColumnName.operatorType.operators);
                     
                        filterSpecifierPanel.add(columnNameLabel);
                        filterSpecifierPanel.add(operators);
                     
                        final int index = cb.getSelectedIndex();
                     
                        if (selectedColumnName.operatorType == OperatorType.BOOLEAN)
                        {
                        
                           final JCheckBox checkBox = new JCheckBox();
                        
                           filterSpecifierPanel.add(checkBox);
                        
                           createFilterButton
                              .addActionListener
                              (
                                 _ ->
                                 {
                                 
                                    final RowFilter<DefaultTableModel, Integer> rowFilter =
                                       new RowFilter<>()
                                       {
                                       
                                          public boolean include(final RowFilter.Entry<? extends DefaultTableModel, ? extends Integer> entry)
                                          {
                                          
                                             if (!(entry.getValue(index) instanceof Boolean b))
                                             {
                                             
                                                throw new IllegalArgumentException("?");
                                             
                                             }
                                          
                                             if (!(operators.getSelectedItem() instanceof final Operator operator))
                                             {
                                             
                                                throw new IllegalArgumentException("?");
                                             
                                             }
                                          
                                             return
                                                switch (operator)
                                                {
                                                
                                                   case EQUAL     -> b == checkBox.isSelected();
                                                   case NOT_EQUAL -> b != checkBox.isSelected();
                                                   default        -> throw new IllegalArgumentException("?");
                                                
                                                };
                                          
                                          }
                                       
                                       };
                                 
                                    sortAndFilter.setRowFilter(rowFilter);
                                 
                                    filterPrompt.dispose();
                                 
                                 }
                              );
                        
                        }
                        
                        else
                        {
                        
                        
                        
                        }
                     
                     
                           /*
                     
                              final JTextField filterTextField = new JTextField(10);
                     
                              filterSpecifierPanel.add(filterTextField);
                     
                           */
                     
                        filterPrompt.pack();
                        filterPrompt.repaint();
                     
                     }
                  );
            
               final JPanel mainPanel = new JPanel();
               mainPanel.setLayout(new GridLayout(0, 1));
            
               mainPanel.add(cb);
               mainPanel.add(filterSpecifierPanel);
               mainPanel.add(createFilterButton);
            
               filterPrompt.getContentPane().add(mainPanel);
            
               filterPrompt.pack();
            
               //add a filter onto the sortAndFilter
            
               //add a menu item to remove that particular filter
            
               //consider OR filters as well as AND filters?
            
               filterPrompt.setVisible(true);
            
            }
         
         };
   
      final Action clearAllFilters =
         new AbstractAction("Clear all filters")
         {
         
            public void actionPerformed(final ActionEvent e)
            {
            
               System.out.println("Clicked a menu item! Here is e = " + e);
            
            }
         
         };
   
      clearAllFilters.setEnabled(false);
   
      final JPopupMenu popupMenu = new JPopupMenu("Here is a label");
      popupMenu.add(addFilter);
      popupMenu.add(clearAllFilters);
   
      final JTableHeader headers = table.getTableHeader();
      headers.setComponentPopupMenu(popupMenu);
   
      JScrollPane scrollPane = new JScrollPane(table);
   
      frame.getContentPane().add(scrollPane);
      frame.pack();
   
      frame.setVisible(true);
   
   }

}
