package ru.tinkoff;

import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.profile.LinuxPerfAsmProfiler;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;

import java.util.concurrent.TimeUnit;

public class Main {
    public static void main(String[] args) throws Exception {
        Options options = new OptionsBuilder()
                .include(ShiftOrBench.class.getSimpleName())
                .shouldFailOnError(true)
                .addProfiler(LinuxPerfAsmProfiler.class)
                .mode(Mode.Throughput)
                .timeUnit(TimeUnit.SECONDS)
                .forks(1)
                .warmupForks(1)
                .warmupIterations(1)
                .warmupTime(TimeValue.seconds(5))
                .measurementIterations(5)
                .measurementTime(TimeValue.seconds(20))
                .build();
        new Runner(options).run();
    }
}