package ru.tinkoff;

public class ScalarShiftOr implements Matcher {
    private long[] filter;
    private long finishMask;
    public ScalarShiftOr(byte[] needle) {
        filter = new long[256];
        for (int i = 0; i < 256; i++)
            filter[i] = -1L;

        for (int i = 0; i < needle.length; i++) {
            long mask = ~(1L << i);
            int low = Character.toLowerCase(needle[i]) & 0xFF;
            int upper = Character.toUpperCase(needle[i]) & 0xFF;
            filter[low] = filter[low] & mask;
            filter[upper] = filter[upper] & mask;
        }
        finishMask = 1L << (needle.length - 1);
    }

    @Override
    public boolean matches(byte[] haystack) {
        long state = -1L;
        for (byte ch : haystack) {
            state <<= 1;
            state |= filter[ch];
            if ((state & finishMask) == 0) return true;
        }
        return false;
    }
}
