package ru.tinkoff;

import org.openjdk.jmh.annotations.*;
import org.openjdk.jmh.infra.Blackhole;

import java.nio.charset.StandardCharsets;

@State(Scope.Thread)
@BenchmarkMode(Mode.Throughput)
@Fork(1)
public class ShiftOrBench {
    byte[] data = "Request completed. HttpStatus: OK, content length 120".getBytes(StandardCharsets.UTF_8);

    byte[] pattern = "content".getBytes(StandardCharsets.UTF_8);

    Matcher scalar = new ScalarShiftOr(pattern);

    Matcher vector = new VectorShiftOr(pattern);

    @Benchmark
    public void scalar(Blackhole bh) {
        boolean result = scalar.matches(data);
        bh.consume(result);
    }

    @Benchmark
    public void vector(Blackhole bh) {
        boolean result = vector.matches(data);
        bh.consume(result);
    }
}
