package ru.tinkoff;

import jdk.incubator.vector.LongVector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;

public class VectorShiftOr implements Matcher {
    long[] filter;
    long[] finishMask;

    public VectorShiftOr(byte[] needle) {
        filter = new long[256 * 4];
        finishMask = new long[4];
        for (int i = 0; i < 256 * 4; i++)
            filter[i] = -1L;

        for (int i = 0; i < needle.length; i++) {
            long mask = ~(1L << i);
            int low = Character.toLowerCase(needle[i]) & 0xFF;
            int upper = Character.toUpperCase(needle[i]) & 0xFF;
            filter[low * 4] = filter[low] & mask;
            filter[upper * 4] = filter[upper] & mask;
        }
        finishMask[0] = 1L << (needle.length - 1);
        for (int i = 1; i < 4; i++) {
            finishMask[i] = 1L << 63;
        }
    }

    @Override
    public boolean matches(byte[] haystack) {
        VectorSpecies<Long> species = LongVector.SPECIES_256;
        LongVector state = LongVector.broadcast(species, -1L);
        LongVector finish = LongVector.fromArray(species, finishMask, 0);
        LongVector zero = LongVector.zero(species);
        for (byte ch : haystack) {
            state = state.lanewise(VectorOperators.LSHL, 1);
            LongVector mask = LongVector.fromArray(species, filter, (int)ch * 4);
            state = state.or(mask);
            if (state.and(finish).eq(zero).anyTrue()) return true;
        }
        return false;
    }
}
