/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.phansson.example;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

/**
 *  Demonstrates JDK-806818 using a simple Swing application.
 */
public class JDKBug806818Example {
    
    private static JFrame frame;

    private static void createAndShowGUI() {
        frame = new JFrame("JDK Bug 806818 Example");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
 
        JButton btn = new JButton("Push me");
        btn.addActionListener((ActionEvent e) -> { 
            JOptionPane.showMessageDialog(frame, "I'm alive!", "Hello", JOptionPane.INFORMATION_MESSAGE);  
        });
        frame.getContentPane().add(btn);
           
        //Display the window.
        frame.pack();
        frame.setSize(new Dimension(800, 600));
        frame.setVisible(true);
    }
        
    public static String getPassword() {
        ClassLoader cloader = Thread.currentThread().getContextClassLoader();

        try {
            Class<?> loadedClass = cloader.loadClass("foobar");
            System.out.println(loadedClass.getName());
        } catch (ClassNotFoundException ex) {
        }
        return (String)JOptionPane.showInputDialog(
                    frame,
                    "Password : ",
                    "Credentials for " + System.getProperty("user.name"),
                    JOptionPane.PLAIN_MESSAGE,
                    null,
                    null,
                    null);
    }
 
    
    public static void main(String[] args) throws MalformedURLException, IOException, InterruptedException {
        
        // Use dummy proxy at localhost
        // If you don't have a network proxy at hand that uses 'Negotiate' scheme
        // for authentication then you can alternatively use the dummy proxy:
        //    https://bitbucket.org/phansson/dummy-proxy-server
        System.setProperty("http.proxyHost", "localhost");
        System.setProperty("http.proxyPort", "3128");

        // Install our custom class loader
        Thread.currentThread().setContextClassLoader(new CustomClassLoader());
        
        // Install our simple Authenticator
        Authenticator.setDefault(new MyAuthenticator());
        
        // Show GUI
        javax.swing.SwingUtilities.invokeLater(() -> { createAndShowGUI(); });

        // Allow some time for the UI to be shown. Otherwise the UI won't
        // even be shown because the Swing EDT deadlocks with the current thread
        // almost immediately.
        Thread.sleep(10000);
        
        URL url = new URL("http://www.oracle.com");
        
        // this will now cause the deadlock
        try (InputStream is = url.openStream()) {
            // read from stream and discard
            byte[] buffer = new byte[1024];
            while (is.read(buffer) != -1) {}
        }
    }
    
}
