/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.phansson.example;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.SwingUtilities;

/**
 * Authenticator which brings up a dialog where it asks
 * for password.
 */
public class MyAuthenticator extends Authenticator {

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        
        FutureTask<String> ft = new FutureTask(() -> JDKBug806818Example.getPassword());
        
        SwingUtilities.invokeLater(ft);
        
        try {
            String pwd = ft.get();   // this will block
            if (pwd == null) { // user pressed 'cancel' in dialog
                return null;
            }
            return new PasswordAuthentication(System.getProperty("user.name"), pwd.toCharArray());
        } catch (InterruptedException | ExecutionException ex) {
            return null;
        }
    }
    
    
    
}
