import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

class Reproducer {
    public static void main(String[] args) throws Exception {

        Oid KERBEROS_V5 = new Oid("1.2.840.113554.1.2.2");
        GSSManager manager = GSSManager.getInstance();
        GSSName name = manager.createName("remote/localhost@JBOSS.ORG", GSSName.NT_USER_NAME, KERBEROS_V5);

        GSSCredential credential = manager.createCredential(name, GSSCredential.INDEFINITE_LIFETIME, new Oid[]{KERBEROS_V5}, GSSCredential.INITIATE_AND_ACCEPT);

        // use new GSSManager to force initialization of ProviderList.factories from initSecContext()
        // (will push wrong initialized SunNativeProvider.INSTANCE into)
        manager = GSSManager.getInstance();

        GSSContext serverContext = manager.createContext(credential);
        GSSContext clientContext = manager.createContext(name, KERBEROS_V5, credential, GSSContext.INDEFINITE_LIFETIME);

        // using channel binding without initAddr/acceptAddr causes SIGSEGV without patch
        ChannelBinding cb = new ChannelBinding("channel-binding-data".getBytes());
        serverContext.setChannelBinding(cb);
        clientContext.setChannelBinding(cb);

        byte[] token = new byte[0];
        token = clientContext.initSecContext(token, 0, token.length);
        token = serverContext.acceptSecContext(token, 0, token.length);
        token = clientContext.initSecContext(token, 0, token.length);

        System.out.println("client established: " + clientContext.isEstablished());
        System.out.println("server established: " + serverContext.isEstablished());
    }
}
