import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.VmIdentifier;
import sun.tools.jps.Arguments;

import java.io.IOException;
import java.util.Set;

public class AgentLoader {
	public static void main(String[] args) throws Exception {
		HostIdentifier hostId = new Arguments(args).hostId();
		MonitoredHost monitoredHost =
				MonitoredHost.getMonitoredHost(hostId);

		// get the set active JVMs on the specified host.
		Set<Integer> jvms = monitoredHost.activeVms();

		int targetPid = 0;
		for (Integer pid: jvms) {
			String candidate = MonitoredVmUtil.mainClass(monitoredHost.getMonitoredVm(new VmIdentifier("//" + pid), 0), new Arguments(args).showLongPaths());
			if ("LongRunning".equals(candidate)) {
				targetPid = pid;
				break;
			}
		}

		VirtualMachine jvm = VirtualMachine.attach(Integer.toString(targetPid));
		jvm.loadAgent("/tmp/untitled/target/untitled-1.0-SNAPSHOT.jar");
		jvm.detach();
	}
}
